#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include <string.h>
#include <float.h>

#include "cree_png.h"

#include "bufrlib.h"
#include "bufr_io.h"

radar_data_t b;

int subset_courant = 1;

int get_elt (dd *d, varfl val) 
{
  int got_it = 1;
  if ((subset_courant == 1) && bufr_check_fxy (d, 0,5,33)) {
	b.img.psizex = val;
      }
      else if ((subset_courant == 1) && bufr_check_fxy (d, 0,6,33)) {
	b.img.psizey = val;
      }
      else if ((subset_courant == 1) && bufr_check_fxy (d, 0,30,21)) {
	b.img.ncols = val;
      }
      else if ((subset_courant == 1) && bufr_check_fxy (d, 0,30,22)) {
	b.img.nrows = val;
      }
      else if ((subset_courant == 1) && bufr_check_fxy (d, 0,7,21)) {
	b.polar.elangle = val;
      }
      else if ((subset_courant == 1) && _replicating && bufr_check_fxy (d, 0, 21, 216)) { 
	static int n = 0;
	if (n == 0) {
	  fprintf(stderr, "Replication table de seuils de taille %d\n", _replicating);
	  assert(_replicating < 255);
	  b.img.scale.nvals = _replicating;
	  n = _replicating;
	}
	b.img.scale.vals[n-_replicating] = val;
	if (_replicating == 1) {
	  n = 0;
	}
      }
      else if ((subset_courant == 1) && _replicating && bufr_check_fxy (d, 0, 30, 1)) { 
	static int n = 0;
	if (n == 0) {
	  assert(_replicating == b.img.nrows*b.img.ncols);
	  n = b.img.nrows*b.img.ncols;
	  fprintf(stderr, "Replication d'un tableau de %d elts\n", n);
	  b.img.data = calloc(n, sizeof(unsigned short));
	  assert(b.img.data);
	}
	b.img.data[n-_replicating] = val;
	if (_replicating == 1) {
	  n = 0;
	}
      }
      else {
	got_it = 0;
      }
      return got_it;
}

int get_seq (dd * d, varfl *vv)
{
  int got_it = 1;
        /* WMO block and station number */
       if ((subset_courant == 1) && bufr_check_fxy (d, 3,1,1)) { 
	  int i = 0;
	  b.wmoblock = vv[i++];
	  b.wmostat = vv[i++];
       }
       else if ((subset_courant == 1) && bufr_check_fxy (d, 3,21,11)) { 
	  int i = 0;
	  b.img.type = vv[i++];
	  i++;
	  b.img.grid = vv[i++];
	  assert(b.img.grid == 0);
	} 
       else if ((subset_courant == 1) && bufr_check_fxy (d, 3,1,11)) { 
	  int i = 0;
	  b.meta.year = vv[i++];       /* Date */
	  b.meta.month = vv[i++];
	  b.meta.day = vv[i++];
	} 
	else if ((subset_courant == 1) && bufr_check_fxy (d, 3,1,13)) { 
	  int i = 0;
	  b.meta.hour = vv[i++];       /* Time */
	  b.meta.min = vv[i++];
	  b.meta.sec = vv[i++];
	}
	else if ((subset_courant == 1) && bufr_check_fxy (d, 3,1,21)) { 
	  int i = 0;
	  b.meta.radar.lat = vv[i++];  /* Position */
	  b.meta.radar.lon = vv[i++];
	} else if ((subset_courant == 1) && bufr_check_fxy (d, 3,21,10)) { 
	  b.meta.radar_height = vv[1]+vv[2];
	}
	else {
	got_it = 0;
      }
      return got_it;
}

static void zoom(radar_data_t *b)
{
  int ncols = b->img.ncols, nrows = b->img.nrows;
  unsigned short *ptr = b->img.data;
  unsigned short *ptr2 = calloc(ncols*nrows/4, sizeof(unsigned short));
  int i, j;

  assert((ncols%4 == 0) && (nrows%4 == 0));
  for (i = ncols/4; i < 3*ncols/4; ++i) {
    for (j = nrows/4; j < 3*nrows/4; ++j) {
      ptr2[i - ncols/4  + (j - nrows/4)*ncols/2] = ptr[i + j*ncols]; 
    }
  }
  b->img.ncols /= 2;
  b->img.nrows /= 2;
  b->img.data = ptr2;
  free(ptr);
}

/*===========================================================================*/

int vraie_taille_palette = 63;
double seuils_france54[63] = {
                0.25,
                0.50,
                0.75,
                1.00,
                1.25,
                1.50,
                1.75,
                2.00,
                2.25,
                2.50,
                2.75,
                3.00,
                3.25,
                3.50,
                3.75,
                4.00,
                4.25,
                4.50,
                4.75,
                5.00,
                5.25,
                5.50,
                5.75,
                6.00,
                6.25,
                6.50,
                6.75,
                7.00,
                7.25,
                7.50,
                7.75,
                8.00,
                8.25,
                8.50,
                8.75,
                9.00,
                9.25,
                9.50,
                9.75,
               10.00,
               10.25,
               10.50,
               10.75,
               11.00,
               11.25,
               11.50,
               11.75,
               12.00,
               12.25,
               12.50,
               12.75,
               13.00,
               13.25,
               13.50,
               13.75,
               14.00,
               14.25,
               14.50,
               14.75,
               15.00,
               15.25,
               15.50,
               15.75 };

  //     0.5,   1, 1.5,   2, 2.5,   3,  3.5,
  //  4, 4.5,   5, 5.5,   6,   9,   12,   15 };

png_color palette[256] = {
{ 32, 36, 128 },
{ 32, 41, 129 },
{ 33, 47, 131 },
{ 33, 52, 132 },
{ 33, 57, 134 },
{ 34, 62, 135 },
{ 34, 68, 137 },
{ 35, 74, 138 },
/* { 35, 79, 140 }, */
/* { 35, 85, 141 }, */
/* { 36, 91, 143 }, */
/* { 36, 97, 144 }, */
/* { 36, 103, 146 }, */
/* { 37, 109, 147 }, */
/* { 37, 116, 149 }, */
/* { 38, 122, 150 }, */
/* { 38, 129, 152 }, */
/* { 38, 135, 153 }, */
/* { 39, 142, 155 }, */
/* { 39, 149, 156 }, */
/* { 39, 156, 158 }, */
/* { 40, 159, 156 }, */
/* { 40, 161, 151 }, */
/* { 41, 162, 147 }, */
/* { 41, 164, 143 }, */
/* { 41, 165, 138 }, */
/* { 42, 167, 134 }, */
/* { 42, 168, 129 }, */
/* { 42, 170, 124 }, */
/* { 43, 171, 119 }, */
/* { 43, 173, 114 }, */
/* { 44, 174, 109 }, */
/* { 44, 176, 104 }, */
/* { 44, 177, 98 }, */
/* { 45, 179, 93 }, */
/* { 45, 180, 87 }, */
/* { 45, 182, 82 }, */
/* { 46, 183, 76 }, */
/* { 46, 185, 70 }, */
/* { 47, 186, 64 }, */
/* { 47, 188, 58 }, */
/* { 47, 189, 52 }, */
/* { 50, 191, 48 }, */
/* { 57, 192, 48 }, */
/* { 64, 194, 48 }, */
/* { 72, 195, 49 }, */
/* { 79, 197, 49 }, */
/* { 87, 198, 50 }, */
/* { 94, 200, 50 }, */
/* { 102, 201, 50 }, */
{ 110, 203, 51 },
{ 110, 203, 51 },
{ 110, 203, 51 },
//{ 118, 204, 51 },
//{ 126, 206, 51 },
//{ 134, 207, 52 },
//{ 143, 209, 52 },
//{ 151, 210, 53 },
//{ 160, 212, 53 },
{ 168, 213, 53 },
{ 177, 215, 54 },
{ 186, 216, 54 },
{ 195, 218, 54 },
{ 204, 219, 55 },
{ 213, 221, 55 },
{ 222, 222, 56 },
{ 224, 216, 56 },
{ 225, 209, 56 },
{ 227, 203, 57 },
{ 228, 196, 57 },
{ 230, 189, 57 },
{ 231, 182, 58 },
{ 233, 175, 58 },
{ 234, 168, 59 },
{ 236, 161, 59 },
{ 237, 154, 59 },
{ 239, 146, 60 },
{ 240, 139, 60 },
{ 242, 131, 60 },
{ 243, 123, 61 },
{ 245, 116, 61 },
{ 246, 108, 62 },
{ 248, 100, 62 },
{ 249, 91, 62 },
{ 251, 83, 63 },
{ 252, 75, 63 },
{ 254, 66, 63 },
{ 254, 64, 64 } 
};

  /*                           {255, 255, 255}, /\* "White" *\/ */
  /* 			    {72,  61, 139},  /\* "DarkSlateBlue" *\/ */
  /* 			    {0, 0, 205},     /\* "MediumBlue" *\/ */
  /* 			    {30, 144, 255},  /\* "DodgerBlue" *\/ */
  /* 			    {173, 216, 230}, /\* "LightBlue" *\/ */
  /* 			    {85, 107,  47},  /\* "DarkOliveGreen" *\/ */
  /* 			    {60, 179, 113},  /\* "MediumSeaGreen" *\/ */
  /* 			    {127, 255, 212}, /\* "Aquamarine" *\/ */
  /* 			    {127, 255,   0}, /\* "Chartreuse" *\/ */
  /* 			    {255, 255,   0}, /\* "Yellow" *\/ */
  /* 			    {240, 230, 140}, /\* "khaki" *\/ */
  /* 			    {222, 184, 135}, /\* "burlywood" *\/ */
  /* 			    {255, 165,   0}, /\* "Orange" *\/ */
  /* 			    {160,  82,  45}, /\* "sienna" *\/ */
  /* 			    {255,   0,   0}  /\* "Red" *\/ */
  /* }; */

png_color no_value = {255, 192, 203}; /* Pink */

int kml = 0;

/*===========================================================================*/

static char *usage = "Usage: martinique [-k] [-t] [-d tabdir] input_file image_file_base\n";

int main (int argc, char** argv)

{
    char destfile[200], buffile[200];
    char *table_dir = NULL;
    sect_1_t s1;
    bufr_t bufr_msg;    /* structure holding encoded bufr message */

    /* initialize variables */

    memset (&bufr_msg, 0, sizeof (bufr_t));
    memset (&s1, 0, sizeof (sect_1_t));

    /* check command line parameter */

    while (argc > 1 && *argv[1] == '-')
    {
        if (*(argv[1] + 1) == 'd')
        {
            if (argc < 2)
            {
                fprintf (stderr, "Missing parameter for -d\n\n%s", usage);
                exit (EXIT_FAILURE);
            }
            table_dir = argv[2];
            argc--;
            argv++;
        }
        else if (*(argv[1] + 1) == 'k')
        {
            kml = 1;
        }
        else if (*(argv[1] + 1) == 't')
        {
	  kml = 2;
        }
        else if (*(argv[1] + 1) != '\0')
        {
            fprintf (stderr, "Invalid parameter %s\n\n%s", argv[1], usage);
            exit (EXIT_FAILURE);
        } else {
	  break;
	}
        argc--;
        argv++;
    }

    if ((kml == 2) && (argc == 2)) {
      strcpy (buffile, argv[1]);
      kml = 0;
      write_png(NULL, buffile);
      exit (EXIT_SUCCESS);
    }
 
    /* Get input- and output-filenames from the command-line */

    if (argc < 3)
    {
        fprintf (stderr, "%s", usage);
        exit (EXIT_FAILURE);
    }
    strcpy (buffile, argv[1]);
    strcpy (destfile, argv[2]);

    /* read source-file. Therefore allocate memory to hold the complete
       BUFR-message */

    if (!bufr_read_file2 (&bufr_msg, buffile)) {
        bufr_free_data (&bufr_msg);
        exit (EXIT_FAILURE);
    }

    /* decode section 1 */

    if (!bufr_decode_sections01 (&s1, &bufr_msg)) {
        bufr_free_data (&bufr_msg);
        exit (EXIT_FAILURE);
    }

    /* Write section 1 to stderr */

    if (!bufr_header_to_file (&s1, NULL)) {
        bufr_free_data (&bufr_msg);
        exit (EXIT_FAILURE);
    }

    /* read descriptor tables */

    if (read_tables (table_dir, s1.vmtab, s1.vltab, s1.subcent, 
                     s1.gencent) < 0) {
        bufr_free_data (&bufr_msg);
        free_descs();
        exit (EXIT_FAILURE);
    }

    /* decode data descriptor- and data-section now */

    if (!bufr_to_data (destfile, &bufr_msg)) {
        fprintf (stderr, "unable to decode BUFR-message !\n");
        bufr_free_data (&bufr_msg);
        free_descs();
        exit (EXIT_FAILURE);
    }

    {
        int i;
        for (i = 0; i < 6; i++) {
            fprintf (stderr, "section %d length = %d\n", i, bufr_msg.secl[i]);
        }
    }

    zoom(&b);
    zoom(&b);
    write_png(&b, destfile);
    
    bufr_free_data (&bufr_msg);
    free_descs();
    exit (EXIT_SUCCESS);
}

/* end of file */

